\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 19))
  markup-system-spacing = #'((basic-distance . 25))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă

\header {
  title = "Să se umple gurile noastre "
  subtitle = "Întărește-ne pe noi"
  subsubtitle = " "
  composer = \markup \center-column { "după Dimitrie Cunțan" \small 
  "(1837 - 1910)" }
  %meter = "Andante"
  tagline=""
}

global = {
  \key f \major
  %\time 2/4
  \set Staff.midiInstrument = "clarinet"
}

womenWords = \lyricmode {
  A -- min.
  %Să se um -- ple gu -- ri -- le noas -- tre de la -- u -- da Ta, 
  %Doam -- ne, ca să lă -- u -- dăm  sla -- va Ta; 
  %că ne-ai în -- vred -- ni -- cit %pe noi 
  %a ne îm -- păr -- tă -- şi  cu sfin -- te -- le,
  %făr' de moar -- te. prea -- cins -- ti -- te -- le
  %şi de vi -- a -- ţă fă -- că -- toa -- re -- le Ta -- le Tai -- ne.
  În -- tă -- reş -- te -- ne pe noi în -- tru sfin -- ţe -- ni -- a Ta,
  toa -- tă zi -- ua să ne în -- vă -- ţăm __ drep -- ta -- tea Ta.
  A -- li -- lu -- i -- a, a -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a.
}
menWords = \lyricmode {
  A -- min.
  %Să se um -- ple gu -- ri -- le noas -- tre de la -- u -- da Ta, 
  %Doam -- ne, ca să lă -- u -- dăm  sla -- va Ta; 
  %că ne-ai în -- vred -- ni -- cit %pe noi 
  %a ne îm -- păr -- tă -- şi  cu sfin -- te -- le,
  %făr' de moar -- te. prea -- cins -- ti -- te -- le
  %şi de vi -- a -- ţă fă -- că -- toa -- re -- le Ta -- le Tai -- ne.
  În -- tă -- reş -- te -- ne pe noi în -- tru sfin -- ţe -- ni -- a Ta,
  toa -- tă zi -- ua să ne în -- vă -- ţăm drep -- ta -- tea Ta.
  A -- li -- lu -- i -- a, a -- li -- lu -- i -- a,
  a -- li -- lu -- i -- a.
}

sopMusic = \relative c' {
  f2 a \bar"||"
  a4 a a g f g a a g a b( c) b a g2
  g4 g a g f f d e f( g f) e f2 g a
  a4 a a( g) a( b) c2 b4 c d2 c4( b) a2
  g4 a b2 g f2
  \bar "|."
}

altoMusic = \relative c' {
  f2 f 
  f4 f f e d e f f e f g( a) g f e2
  e4 e f e d d d d d2. d4 d2 e f
  f4 f f( e) f( g) a2 g4 a b2 a4( g) f2
  e4 g f2 e f
}

tenorMusic = \relative c {
  f2 f
  f4 f f g a b c c c c d( c) b a g2
  g4 g g g f f f f f( g a) b4 c2 c c
  c4 c c2 c c d4 e f2 e2 c2
  c4 c d2 c4( b) a2
}

bassMusic = \relative c {
  f2 f 
  f4 f f e d c c c c c f2 e4 f c2
  c4 c c c b b b b b2. b4 b2 c f
  f4 f f2 f f e4 f b,2 c f e4 f b,2 c f
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \new Voice { \voiceOne \global \sopMusic }
      \addlyrics { \womenWords }
      \new Voice { \voiceTwo \global \altoMusic }
    >>

    \new Staff = "men" <<
      \clef bass
      \new Voice { \voiceOne \global \tenorMusic }
      \new Voice { \voiceTwo \global \bassMusic }
      \addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 80
  \context { \Voice \remove "Dynamic_performer" }

}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altoMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}